<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>About Us - Volunteer Travel Adventure</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <?php include 'header-link.php' ?>
</head>

<body class="service-details-page">

  <?php include 'nav-bar.php' ?>

  <main class="main">

    <!-- Page Title -->
    <div class="page-title">
      <div class="heading">
        <div class="container">
          <div class="row d-flex justify-content-center text-center">
            <div class="col-lg-8">
              <h1 class="heading-title"> About Us </h1>
              
            </div>
          </div>
        </div>
      </div>
      <nav class="breadcrumbs">
        <div class="container">
          <ol>
            <li><a href="index">Home</a></li>
            <li class="current"> / About Us</li>
          </ol>
        </div>
      </nav>
    </div><!-- End Page Title -->


	
	<section id="about" class="about section">
 
      <div class="container">

        <div class="row gy-4">

         

          <div class="col-lg-7 order-1 order-lg-1 content" data-aos="fade-up" data-aos-delay="200">
            <h3> Our Mission</h3>
            <p class="">
              At Volunteers Adventure Travel, our mission is to inspire and connect individuals with opportunities to make a meaningful impact in developing communities around the world. We are dedicated to fostering cultural exchange, promoting sustainable practices, and empowering local populations through volunteerism. By creating transformative travel experiences that blend adventure with purpose, we strive to cultivate compassion, understanding, and lasting change, one journey at a time.

            </p>
			
			
          </div>
		  
		   <div class="col-lg-5 order-1 order-lg-2" data-aos="fade-up" data-aos-delay="100">
            <img src="assets/img/about.jpeg" class="img-fluid rounded" alt="">
          </div>

        </div>

      </div>

    </section><!-- /About Section -->
	
		<section id="about" class="about section">
 
      <div class="container">

        <div class="row gy-4">

         

          <div class="col-lg-7 order-1 order-lg-2 content" data-aos="fade-up" data-aos-delay="200">
            <h3> Background </h3>
            <p class="">
				Volunteers Adventure Travel was founded on the belief that travel can be a powerful catalyst for positive change. Our journey began with a passion for exploration and a deep commitment to social impact. Recognizing the unique opportunity to connect enthusiastic travelers with meaningful volunteer experiences, we set out to create a platform that empowers individuals to make a difference while discovering new cultures.<p/>
				Inspired by personal experiences in volunteering and travel, our founder envisioned a business that not only facilitates community engagement but also promotes sustainable tourism practices. With a focus on developing countries, we aim to bridge the gap between travelers and local communities, fostering mutual understanding and respect.<p/>
				
				Since our inception, we have dedicated ourselves to partnering with established organizations and local NGOs to ensure that our programs are effective and impactful. Our diverse range of volunteer opportunities – from education and health initiatives to environmental conservation and community development – reflect our commitment to addressing pressing social issues while enriching the lives of our volunteers.<p/>
				As we grow, our goal remains steadfast: <p/>
				To inspire a global community of compassionate travelers who are eager to contribute to meaningful change.<p/>
				Together, we can create lasting connections and empower communities, one volunteer experience at a time.



            </p>
			
			
          </div>
		  
		   <div class="col-lg-5 order-1 order-lg-1" data-aos="fade-up" data-aos-delay="100">
            <img src="assets/img/mission.jpeg" class="img-fluid rounded" alt="">
          </div>

        </div>

      </div>

    </section><!-- /About Section -->
	
	<section id="team" class="team section bg-light">

      <!-- Section Title -->
      <div class="container section-title pb-4" data-aos="fade-up">
        <h2>Team</h2>
        <p class="text-dark">Meet Alavy Islam, Founder of Volunteers Adventure Travel</p>
      </div><!-- End Section Title -->

      <div class="container">

        <div class="row gy-3 m-auto">
 

          <div class="col-lg-3 col-md-6 m-auto" data-aos="fade-up" data-aos-delay="400">
            <div class="member">
              <img src="assets/img/alavi.jpeg" class="img-fluid rounded"  width="70%">
              <div class="member-info">
                <div class="member-info-content">
                  <h4>Alavy Islam</h4>
                  <span>Founder</span>
                  <div class="social">
                    <a href=""><i class="bi bi-twitter-x"></i></a>
                    <a href=""><i class="bi bi-facebook"></i></a>
                    <a href=""><i class="bi bi-instagram"></i></a>
                    <a href=""><i class="bi bi-linkedin"></i></a>
                  </div>
                </div>
              </div>
            </div>
          </div> 
		  
		  <p class="text-dark">
			
			Alavy Islam is a passionate advocate for social change and the founder of Volunteers Adventure Travel. Growing up in Australia, Alavy has over 15 years of experience as a Civil Engineer specializing in stormwater drainage and flooding, bringing a wealth of expertise in design consultancy to the organization. She has studied and pursued a Master’s degree in International and Community Development, which has greatly influenced her commitment to creating impactful volunteer opportunities.<br/><br/>
			
			Alavy’s journey into the world of volunteering began during her time in South Africa in 2012, where she participated in a volunteer adventure tour that ignited her passion for combining travel with meaningful work. In 2013, she continued her journey in Nepal, assisting a local NGO on a water resource project. From 2017 to 2020, while on an international engineering assignment in South Africa, Alavy dedicated four years to volunteering at a local orphanage in Cape Town. This experience opened her eyes to the corruption that can exist within NGOs, where many donations fail to reach those in need. This realization inspired her to create a space that prioritizes transparency and integrity, ensuring that 100% of volunteering donation funds go directly to the projects and initiatives that truly benefit the communities served.<br/><br/>
			
			As a lover of travel, Alavy believes that making a difference while exploring the world is the most fulfilling way to connect with local cultures and forge genuine friendships. Her experiences in both Nepal and South Africa reinforced her commitment to combining adventure with purpose.<br/><br/>
			
			Alavy’s vision for Volunteers Adventure Travel is to create a platform that is honest and transparent, allowing travelers to experience the same kind of fulfilling travel she encountered during her past volunteer experiences. She aims to empower individuals to engage meaningfully with communities while exploring new cultures, ultimately fostering mutual understanding and respect.<br/><br/>
In addition to her professional pursuits, Alavy is an avid mountain climber and hiker, as well as a passionate scuba diver. These interests not only reflect her love for adventure but also inspire her to explore the world’s natural beauty, further enriching her commitment to sustainable tourism.<br/><br/>


		  </p>

        </div>
		

      </div>

    </section>
	
	<?php include 'call-to-action.php'?>

  </main>

  <?php include 'footer.php'?>