<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>Environmental Conservation Details - Volunteer Adventure Travel</title>
    <meta name="description" content="">
    <meta name="keywords" content="">

    <?php include 'header-link.php' ?>
</head>

<body class="service-details-page">

    <?php include 'nav-bar.php' ?>

    <main class="main">

        <!-- Page Title -->
        <div class="page-title">
            <div class="heading">
                <div class="container-fluid">
                    <div class="row d-flex justify-content-center text-center">
                        <div class="col-lg-8">
                            <h1 class="heading-title mt-3">Environmental Conservation Details  </h1>
                            <p class="mb-0">

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <nav class="breadcrumbs" style="background-color: color-mix(in srgb, #332b2b, #2c484e 96%)">
                <div class="container text-white fw-bold">
                    <ol>
                        <li class="text-white"><a href="index" class="text-white">Home </a></li>
                        <li><a href="volunteer-opportunities" class="text-white"> / Volunteer Opportunities / Bangladesh / Volunteer Programs / <a href="" class="text-white">Environmental Conservation Details</a> </li>
                    </ol>
                </div>
            </nav>
        </div><!-- End Page Title -->

        <section id="services" class="services section">

            <!-- Section Title -->
            <div class="container section-title1 " data-aos="fade-up">

                <p>
                   Join our Environmental Conservation program to help protect and preserve natural resources in local communities across Bangladesh. This program aims to educate communities about environmental issues while fostering a sense of responsibility toward their natural surroundings. Volunteers will work closely with locals to implement sustainable practices that benefit both the environment and community health.
                </p>
				
				<h4>Activities: </h4> Volunteers will participate in:
				<p>
					<ul>
						<li> Tree planting initiatives to enhance local biodiversity</li>
						<li> Establishing greenhouse projects focused on vegetable cultivation to promote sustainable agriculture and reduce pollution </li>
						<li> Conducting awareness campaigns about environmental issues and best practices, including waste management and recycling initiatives </li>
						
					</ul>
				</p>

                <h4> Impact </h4>
                <p>
					This program strives to foster environmental responsibility within communities by promoting tree planting, sustainable farming, and waste management practices. Volunteers will actively contribute to increasing local biodiversity, reducing pollution, and raising awareness about critical environmental challenges. Participants will gain valuable practical experience in conservation efforts and deepen their understanding of global environmental issues. Ultimately, the program empowers communities to adopt sustainable practices, ensuring a healthier and more resilient environment for current and future generations.
				</p>


                <h4>Duration:</h4>
                <p>
					A minimum stay of 2 weeks is required to maximize the impact and experience; however, there is also flexibility for longer stays if desired. The longer you commit, the greater the impact you can make in the community.
				</p>

                <h4>Target Audience:</h4>
                <p>
					Open to individuals over the age of 18. However, we accept participants aged 16 to 17 if they can submit a parental consent letter. Participants must have intermediate-level proficiency in English.
				</p>

                <h4>Education:</h4>
                <p>High School Certificate </p>

                <h4>Cost: </h4>
                <p>
					The program fee covers local administrative costs, accommodation, food, transportation, program induction/ orientation on arrival, and community project funding. Please refer to our  <a href="fees.php" target="_blank" style="font-weight:bold;font-size:20px;"> Fees page </a> for detailed information on program costs.
				</p>



                <?php include 'programs.php' ?>

                <?php include 'call-to-action2.php' ?>

            </div><!-- End Section Title -->


        </section>

    </main>

    <?php include 'footer.php' ?>