<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Fees Details - Volunteer Adventure Travel</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <?php include 'header-link.php' ?>
</head>

<body class="service-details-page">

  <?php include 'nav-bar.php' ?>

  <main class="main">

    <!-- Page Title -->
    <div class="page-title">
      <div class="heading">
        <div class="container">
          <div class="row d-flex justify-content-center text-center">
            <div class="col-lg-8">
              <h1 class="heading-title mt-3 logo-text"> Fees Details </h1>
              <p class="mb-0">
              </p>
            </div>
          </div>
        </div>
      </div>
      <nav class="breadcrumbs">
        <div class="container text-dark fw-bold">
          <ol>
            <li><a href="index"> Home </a></li>
            <li> / <a href="fees">Fees </a> / Bangladesh </li>
          </ol>
        </div>
      </nav>
    </div><!-- End Page Title -->

    <section id="more-services" class="more-services section">


      <div class="container">

        <div class="row gy-4">



          <h4> Bangladesh Overview </h4>
			<p> 
            Experience the vibrant culture and rich heritage of Bangladesh while making a positive impact through volunteering. 
			Known for its lush landscapes, friendly locals, and historical landmarks, Bangladesh offers a variety of opportunities 
			for volunteers to engage in community development, education for vulnerable children, women empowerment, health support, 
			and environmental conservation. Volunteers will work alongside local organizations, contributing to meaningful projects 
			that aim to uplift communities and promote sustainable practices.
			
			In addition to volunteering, participants can explore stunning attractions such as <strong> Cox's Bazar </strong>, home to the world's 
			longest natural sandy sea beach, perfect for relaxation and adventure. <strong>Sylhet </strong>, known for its tea gardens and picturesque hills,
			offers a serene escape and cultural richness. <strong>The Sundarbans </strong>, the largest mangrove forest in the world, is a UNESCO World Heritage 
			Site and a haven for biodiversity, including the majestic Bengal tiger.
			
			Bangladesh is also home to three other UNESCO World Heritage Sites: the historic <strong> City of Bagerhat </strong>, known for its beautiful mosques; 
			the ancient <strong>Buddhist Vihara at Paharpur</strong>, an impressive archaeological site; and the Ruins of the <strong>Buddhist Vihara at Mahasthangarh</strong>, 
			which showcases the country’s rich antiquity. Immerse yourself in the colorful traditions of Bangladeshi life while discovering its
			diverse landscapes and heritage.
			</p>
			
			
          <div>
            <ul>
              <li><a href="volunteer-opportunities" target="_blank" style="font-weight:bold;font-size:20px;">	Volunteer Programs </a> </li>
              <li><a href="travel-tour" target="_blank" style="font-weight:bold;font-size:20px;">	Travel Tours </a> </li>
              </ul>
          </div>
		

          <h3><u> Application Process</u></h3>
          <p>
			To participate in our programs, please fill out the application form to ensure you meet our requirements:
		  </p>
		   
         
          <div>
			 <h5>Volunteer Program Requirements: </h5>
            <ul>
              <li>	Must be over 18 years of age.</li>
              <li>	Minimum High School Certificate required.</li>
              <li>	Intermediate level of English proficiency is required.</li>
              <li>	Individuals aged 16 to 17 require a signed parental consent letter.</li>
              <li><strong>Application Required:</strong> To join the volunteer program, please fill out the application form. Once your application is reviewed, you will receive an acceptance email with instructions to proceed to the booking phase. </li>
              </ul>
          </div>
		  
		  
		   <div>
			 <h5>Travel Tour Requirements: </h5>
            <ul>
              <li> Open to anyone over 18 years old. Younger participants must be accompanied by an adult or guardian.</li>
              <li>	While preference is given to individuals participating in the combined package, travelers who are not doing volunteer work are also welcome to join the travel tours.</li>
              <li><strong> 	Direct Booking Available: </strong>Travel tours can be booked directly without an application process.</li>
              </ul>
          </div>
		  
		   <div>
			 <h5>Combined Package Requirements: </h5>
            <ul>
              <li> The combined package includes both volunteer work and travel tour.</li>
             
              <li><strong> 	Application Required:  </strong>Participants must apply to join the combined package as it includes the volunteer program. Following acceptance, you will receive details for booking.</li>
              </ul>
          </div>
		  
		   <h3><u> Program Fees </u></h3>
		   
		   <div>
			 <h5>Volunteer Program Fees: </h5>
            <ul>
			  <li><strong>Cost:</strong> $576 USD for 15 days </li>
			  <li><strong> Single Supplement: :</strong> $40 USD (for all single bookings). Please note that single bookings may have private accommodation upon arrival and during their stay in Dhaka, but shared accommodation with same-sex participants may be required during the volunteer program. </li>
              <li>	<strong>Inclusions:</strong></li>
				<ul>
					<li>Airport pickup </li>
					<li>Induction program</li>
					<li> Accommodation</li>
					<li> Daily meals</li>
					<li> Local transportation</li>
					<li> Program materials and resources</li>
				</ul>
					
              
              
              </ul>
          </div>
		  
		  
		  <div>
			 <h5>Travel Tour Fees: </h5>
            <ul>
			  <li><strong>Cost:</strong> $1250 USD for 15 Days </li>
			  <li><strong> Single Supplement:</strong> $470 USD (for all single bookings). </li>
              <li>	<strong>Inclusions:</strong></li>
				<ul>
					<li> All transportation between destinations </li>
					<li> Accommodation</li>
					<li> Daily meals</li>
					<li> Guided tours</li>
					<li> Cultural experiences</li>
					<li> English-speaking guide</li>
					<li> Airport pickup available on request for an additional fee.</li>
				</ul>
					
              
              
              </ul>
          </div>
		  
		  <div>
			 <h5>Combined Package Fees: </h5>
            <ul>
			  <li><strong>Cost:</strong> $1786 USD for the entire 29-day experience. </li>
			  <li><strong> Single Supplement:</strong> $550 USD (for all single bookings). </li>
              <li><strong>Inclusions:</strong> All features from both the Volunteer Program and Travel Tour.</li>
			  <li><strong>	Note:</strong> Days 1 to 15 are for the Volunteer Program, during which the volunteers will return to Dhaka during the day on Day 15. The Travel Tour will begin 6 to 7 pm on the same day, allowing for a smooth transition from volunteering to travel experiences. </li>
			</ul>
          </div>

			<h3><u> Start Dates </u></h3>
			<p>
				Programs commence on the 1st and 15th of every month.
			</p>
			
			<h3><u> Payment Terms </u></h3>
			<ul>
			  <li><strong>	Full Payment:</strong> The total fee must be paid in full to secure your booking at least 5 working days before the program start date. </li>
			  <li><strong> Terms and Conditions: </strong> A signed waiver and acknowledgment of the Terms and Conditions are required prior to booking and payment </li>
              <li><strong>Payment Methods: </strong> Detailed information on accepted payment methods will be provided upon application app</li>
			  
			</ul>
			
			<h3><u> Cancellation Policy </u></h3>
			<ul>
			  <li><strong>	Full Refund: </strong>Cancellations made more than 10 working days before the program start date will receive a full refund.</li>
			  <li><strong> 50% Refund:  </strong> Cancellations made between 10 working days and 5 working days before the program start date will receive a 50% refund.</li>
              <li><strong> 10% Refund:  </strong> Cancellations made within 5 working days of the program start date will receive a 10% refund.</li>
              <li><strong> No Refund:  </strong> No refunds will be provided once the program has begun.</li>
			  
			</ul>
			
			<h3><u> Next Steps </u></h3>
			<ul>
			  <strong><a href="apply">	Apply Now </a> </strong>Fill out the application form to begin your journey with us for the Volunteer Program or Combined Package.<p/>
			  <strong><a href="apply"> Book Your Spot </a> </strong> Once your application is approved, you can book your spot for the Volunteer Program, Combined Package, or Travel Tour only.
               <p>
				If you have any further questions or need assistance, please feel free to contact us!
				</p>
			</ul>
			
			 
        </div>
		
		<?php //include 'programs.php'?>
 
<?php include 'call-to-action2.php'?> 

      </div>

    </section>

  </main>

  <?php include 'footer.php' ?>