<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>Health Support Details - Volunteer Adventure Travel</title>
    <meta name="description" content="">
    <meta name="keywords" content="">

    <?php include 'header-link.php' ?>
</head>

<body class="service-details-page">

    <?php include 'nav-bar.php' ?>

    <main class="main">

        <!-- Page Title -->
        <div class="page-title">
            <div class="heading">
                <div class="container-fluid">
                    <div class="row d-flex justify-content-center text-center">
                        <div class="col-lg-8">
                            <h1 class="heading-title mt-3">Health Support Details</h1>
                            <p class="mb-0">

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <nav class="breadcrumbs" style="background-color: color-mix(in srgb, #332b2b, #2c484e 96%)">
                <div class="container text-white fw-bold">
                    <ol>
                        <li class="text-white"><a href="index" class="text-white">Home </a></li>
                        <li><a href="volunteer-opportunities" class="text-white"> / Volunteer Opportunities / Bangladesh / Volunteer Programs / <a href="" class="text-white">Health Support Details</a> </li>
                    </ol>
                </div>
            </nav>
        </div><!-- End Page Title -->

        <section id="services" class="services section">

            <!-- Section Title -->
            <div class="container section-title1 " data-aos="fade-up">

                <p>
                    Our Health Support program enables volunteers to work alongside local healthcare providers in Bangladesh to improve access to health services and promote healthy practices. Volunteers will have the opportunity to make a direct impact on community health while gaining valuable insights into the healthcare challenges faced by developing regions.
                </p>
				
				<h4>Activities: </h4> Volunteering will assist in:
				<p>
					<ul>
						<li> Providing health education and promoting hygiene among community members</li>
						<li> Supporting local clinics with patient care and health initiatives </li>
						<li> Assisting with vaccinations for pneumonia, polio, tuberculosis, and other preventable diseases </li>
						<li> Conducting family planning programs and educating women on birth control options </li>
					</ul>
				</p>

                <h4> Impact </h4>
                <p>
                    Volunteers will play a crucial role in enhancing community health by promoting hygiene, supporting clinics, and assisting with vaccination and family planning programs. These efforts help increase health awareness, reduce preventable diseases, and empower individuals to make healthier choices. This experience offers volunteers firsthand insight into the healthcare challenges faced in developing regions, fostering compassion and a deep understanding of global health issues, and ultimately contributing to healthier, more resilient communities
                </p>


                <h4>Duration:</h4>
                <p>
                   A minimum stay of 2 weeks is required to maximize the impact and experience; however, there is also flexibility for longer stays if desired. The longer you commit, the greater the impact you can make in the community.
                </p>

                <h4>Target Audience:</h4>
                <p>
                    Open to individuals over the age of 18. However, we accept participants aged 16 to 17 if they can submit a parental consent letter. Participants must have intermediate-level proficiency in English.
                </p>

                <h4>Education:</h4>
                <p>High School Certificate </p>

                <h4>Cost: </h4>
                <p>
                    The program fee covers local administrative costs, accommodation, food, transportation, program induction/ orientation on arrival, and community project funding. Please refer to our  <a href="fees.php" target="_blank" style="font-weight:bold;font-size:20px;"> Fees page </a> for detailed information on program costs.
                </p>



                <?php include 'programs.php' ?>

                <?php include 'call-to-action2.php' ?>

            </div><!-- End Section Title -->


        </section>

    </main>

    <?php include 'footer.php' ?>