<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>VAT - Volunteer Travel Adventure</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

 <?php include 'header-link.php' ?>
</head>

<body class="index-page">

	<!-- Hero Section -->
		<?php include 'nav-bar.php' ?>
	<!-- Hero Section -->

  <main class="main">

    <!-- Hero Section -->
    <section id="hero" class="hero section dark-background">

      <div id="hero-carousel" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-interval="5000">

        <div class="carousel-item active">
          <img src="assets/img/hero-carousel/hero-carousel-1.jpeg" alt="">
          <div class="carousel-container">
            <h2>Empower Your Journey</h2>
            <p>Discover the world and empower communities as your adventure awaits.
Join us in creating meaningful change through volunteering and immersive travel experiences that enrich lives and foster connections. Your adventure starts here, where every step you take makes a difference.
</p>
            <a href="apply" class="btn-get-started">Get Started</a>
          </div>
        </div> <!-- End Carousel Item -->

        <div class="carousel-item">
          <img src="assets/img/hero-carousel/hero-carousel-2.jpeg" alt="">
          <div class="carousel-container">
            <h2>Journey with a purpose</h2>
            <p>Volunteer to make a difference where it matters most and embark on a journey with a purpose to transform lives</p>
            <a href="volunteer-opportunities" class="btn-get-started">Get Started</a>
          </div>
        </div><!-- End Carousel Item -->

        <div class="carousel-item">
          <img src="assets/img/hero-carousel/hero-carousel-3.jpeg" alt="">
          <div class="carousel-container">
            <h2>Explore with a Purpose</h2>
            <p>Travel to explore the beauty of the world as your journey of discovery starts here
Experience rich cultures, stunning landscapes, and unique adventures that await you, all while making a positive impact on local communities
</p>
            <a href="travel-tour" class="btn-get-started">Get Started</a>
          </div>
        </div><!-- End Carousel Item -->

        <a class="carousel-control-prev" href="#hero-carousel" role="button" data-bs-slide="prev">
          <span class="carousel-control-prev-icon bi bi-chevron-left" aria-hidden="true"></span>
        </a>

        <a class="carousel-control-next" href="#hero-carousel" role="button" data-bs-slide="next">
          <span class="carousel-control-next-icon bi bi-chevron-right" aria-hidden="true"></span>
        </a>

        <ol class="carousel-indicators"></ol>

      </div>

    </section><!-- /Hero Section -->

    <!-- About Section -->
    <section id="about" class="about section bg-light">

      <!-- Section Title -->
      <div class="container section-title d-none" data-aos="fade-up">
        <h2>About</h2>
        <p>Necessitatibus eius consequatur ex aliquid fuga eum quidem sint consectetur velit</p>
      </div><!-- End Section Title -->

      <div class="container">

        <div class="row gy-4">

          <div class="col-lg-5 order-1 order-lg-2" data-aos="fade-up" data-aos-delay="100">
            <img src="assets/img/ctg-hill.jpg" class="img-fluid rounded" alt="">
          </div>

          <div class="col-lg-7 order-2 order-lg-1 content" data-aos="fade-up" data-aos-delay="200">
            <h3 class="logo-text">Welcome to Volunteers Adventure Travel</h3>
            <p>
              At Volunteers Adventure Travel, we believe that it is not just about seeing new places; it’s about making a difference. Our mission is to connect passionate individuals with meaningful volunteering opportunities in developing countries around the world.
            </p>
			<p> 
			We offer a range of programs that empower communities through : 
			</p>
			
            <ul>
              <li><i class="bi bi-check-circle"></i> <span>Education </span></li>
              
              <li><i class="bi bi-check-circle"></i> <span>Environmental Conservation </span></li>
              
              <li><i class="bi bi-check-circle"></i> <span> Health Initiatives</span></li>
			  
              <li><i class="bi bi-check-circle"></i> <span> Community development</span></li>
			  
              <li><i class="bi bi-check-circle"></i> <span> Women’s Empowerment </span></li>
             </ul>
			 
			<p>
				Our unique approach allows volunteers to engage deeply with local cultures, create lasting relationships, and leave a positive impact on the lives of those we serve
			</p>
			 
            
          </div>
		  
		   <div class="col-lg-12 order-2 order-lg-2 content" data-aos="fade-up" data-aos-delay="200">

            <p class="">
              After your volunteering experience, we invite you to explore the wonders of your chosen destination through our curated travel packages. Discover breathtaking landscapes, immerse yourself in rich traditions, and enjoy the adventure of a lifetime, all while supporting sustainable tourism practices.

            </p>
			<p> 
			Join us on this journey of purpose and adventure, and together, let’s create a better world, one volunteer at a time.
			</p>
			
			<a href="about-us" class="read-more d-none"><span>Read More</span><i class="bi bi-arrow-right"></i></a>
			
          </div>
		  
		   

        </div>

      </div>

    </section><!-- /About Section -->

    <!-- Stats Section -->
	<?php // include 'stats.php'?>
    <!-- /Stats Section -->
	<?php include 'call-to-action.php'?>
    <!-- Services Section -->
	<?php include 'service.php'?>
	<
    <!-- /Services Section -->

    <!-- Call To Action Section -->
   

    <!-- More Services Section -->
	<?php // include 'more-service.php'?>
	
    <!-- /More Services Section -->

    <!-- Portfolio Section -->
	<?php // include 'home-gallery.php'?>
    <!-- /Portfolio Section -->

    <!-- Team Section -->
	<?php include 'home-team.php'?>
	
    <!-- /Team Section -->

    <!-- Faq Section -->
	<?php include 'faq.php'?>
	
    <!-- /Faq Section -->

    <!-- Contact Section -->
	<?php // include 'home-contact.php'?>
   <!-- /Contact Section -->

  </main>

  <?php include 'footer.php'?>
