<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>Women Empowerment Details - Volunteer Adventure Travel</title>
    <meta name="description" content="">
    <meta name="keywords" content="">

    <?php include 'header-link.php' ?>
</head>

<body class="service-details-page">

    <?php include 'nav-bar.php' ?>

    <main class="main">

        <!-- Page Title -->
        <div class="page-title">
            <div class="heading">
                <div class="container-fluid">
                    <div class="row d-flex justify-content-center text-center">
                        <div class="col-lg-8">
                            <h1 class="heading-title mt-3">Environmental Conservation Details </h1>
                            <p class="mb-0">

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <nav class="breadcrumbs" style="background-color: color-mix(in srgb, #332b2b, #2c484e 96%)">
                <div class="container text-white fw-bold">
                    <ol>
                        <li class="text-white"><a href="index" class="text-white">Home </a></li>
                        <li><a href="volunteer-opportunities" class="text-white"> / Volunteer Opportunities / Bangladesh / Volunteer Programs / <a href="" class="text-white">Women Empowerment Details Details</a> </li>
                    </ol>
                </div>
            </nav>
        </div><!-- End Page Title -->

        <section id="services" class="services section">

            <!-- Section Title -->
            <div class="container section-title1 " data-aos="fade-up">

                <p>
                    Our Women Empowerment program is dedicated to supporting women in Bangladesh by providing vital skills, education, and advocacy to promote gender equality and economic independence. Volunteers work closely with local organizations to deliver practical training in areas such as entrepreneurship, financial literacy, health education, and income-generating activities. By fostering a supportive environment, the program helps women take charge of their futures, improve their livelihoods, and actively contribute to community development.
                </p>
				
				<h4>Activities: </h4> Volunteers will engage in:
				<p>
					<ul>
						<li> Providing training for disadvantaged women in cattle and poultry farming to enhance livelihoods </li>
						<li> Offering sewing skills training to promote self-sufficiency and craftsmanship </li>
						<li> Teaching handcraft making skills to create income-generating opportunities </li>
						<li> Supporting women in establishing their own small businesses within their villages </li>
					</ul>
				</p>

                <h4> Impact </h4>
                <p>
                    This program aims to empower women by equipping them with practical skills, financial literacy, and confidence to pursue economic independence. Volunteers will support women in developing income-generating activities like farming, sewing, and crafts, creating sustainable opportunities and fostering gender equality. Participants will leave with a deep sense of accomplishment, knowing they contributed to building resilient, self-sufficient communities where women can thrive and lead.
                </p>


                <h4>Duration:</h4>
                <p>
                    A minimum stay of 2 weeks is required to maximize the impact and experience; however, there is also flexibility for longer stays if desired. The longer you commit, the greater the impact you can make in the community.
                </p>

                <h4>Target Audience:</h4>
                <p>
                    Open to individuals over the age of 18. However, we accept participants aged 16 to 17 if they can submit a parental consent letter. Participants must have intermediate-level proficiency in English.
                </p>

                <h4>Education:</h4>
                <p>High School Certificate </p>

                <h4>Cost: </h4>
                <p>
                    The program fee covers local administrative costs, accommodation, food, transportation, program induction/ orientation on arrival, and community project funding. Please refer to our  <a href="fees.php" target="_blank" style="font-weight:bold;font-size:20px;"> Fees page </a> for detailed information on program costs.
                </p>



                <?php include 'programs.php' ?>

                <?php include 'call-to-action2.php' ?>

            </div><!-- End Section Title -->


        </section>

    </main>

    <?php include 'footer.php' ?>